// CodeBreakerView.h : interface of the CCodeBreakerView class
//


#pragma once

#include "DataReader.h"


class CCodeBreakerView : public CFormView
{
protected: // create from serialization only
	CCodeBreakerView();
	DECLARE_DYNCREATE(CCodeBreakerView)

public:
	enum{ IDD = IDD_CODEBREAKER_FORM };

// Attributes
public:
	CCodeBreakerDoc* GetDocument() const;

// Operations
public:

// Overrides
public:
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	virtual void OnInitialUpdate(); // called first time after construct

// Implementation
public:
	virtual ~CCodeBreakerView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:
	CEdit		letters;
	CEdit		code;
	CEdit		status;
	CEdit		num_grams;
	CEdit		solution;
	CEdit		num_all;
	CEdit		num_words;
	CEdit		value_word;
	CEdit		many;

	CComboBox	ngrams;
	CComboBox	prefix;
	
	
	CData		data;

	bool		slovnik;

public:
	int OnCreate(LPCREATESTRUCT cs);





// Generated message map functions
protected:
	DECLARE_MESSAGE_MAP()
public:
	afx_msg void OnGenerate();
	afx_msg void OnSolve();
	afx_msg void OnSlovnik();
	afx_msg void OnScript();
};

#ifndef _DEBUG  // debug version in CodeBreakerView.cpp
inline CCodeBreakerDoc* CCodeBreakerView::GetDocument() const
   { return reinterpret_cast<CCodeBreakerDoc*>(m_pDocument); }
#endif

